<?php
session_start();
require __DIR__ . '/../config.php';
if (!isset($_SESSION['admin_id'])) header('Location: login.php');
$pdo = get_pdo();
$msg = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['create_campaign'])) {
        $stmt = $pdo->prepare("INSERT INTO campaigns (name, template_id, list_id, subject) VALUES (?,?,?,?)");
        $stmt->execute([$_POST['name'], $_POST['template_id'], $_POST['list_id'], $_POST['subject']]);
        $msg = 'Campaign created';
    }
    if (isset($_POST['start_campaign'])) {
        $campaign_id = intval($_POST['campaign_id']);
        // Instruct user to run worker or run via PHP exec
        // We'll mark as sending; worker will process sending
        $pdo->prepare("UPDATE campaigns SET status='sending' WHERE id=?")->execute([$campaign_id]);
        // attempt to run worker in background (may fail depending on server)
        @exec('php ' . __DIR__ . '/../send_worker.php ' . $campaign_id . ' > /dev/null 2>&1 &');
        $msg = 'Campaign started (worker triggered).';
    }
}
$templates = $pdo->query('SELECT * FROM templates')->fetchAll();
$lists = $pdo->query('SELECT * FROM lists')->fetchAll();
$campaigns = $pdo->query('SELECT * FROM campaigns ORDER BY created_at DESC')->fetchAll();
?>
<!doctype html><html><head><meta charset="utf-8"><title>Campaigns</title><link rel="stylesheet" href="/assets/css/style.css"></head><body>
<nav class="top"><a href="dashboard.php">Dashboard</a></nav>
<div class="container">
    <h1>Campaigns</h1>
    <?php if($msg):?><div class="info"><?php echo $msg;?></div><?php endif;?>
    <form method="post">
        <label>Name</label><input name="name" required>
        <label>Subject</label><input name="subject" required>
        <label>Template</label>
        <select name="template_id"><?php foreach($templates as $t){echo "<option value='{$t['id']}'>".htmlspecialchars($t['name'])."</option>";}?></select>
        <label>List</label>
        <select name="list_id"><?php foreach($lists as $l){echo "<option value='{$l['id']}'>".htmlspecialchars($l['name'])."</option>";}?></select>
        <button name="create_campaign" class="btn">Create Campaign</button>
    </form>

    <h3>Existing Campaigns</h3>
    <table class="table"><tr><th>Name</th><th>Subject</th><th>Status</th><th>Action</th></tr>
    <?php foreach($campaigns as $c){
        echo "<tr><td>".htmlspecialchars($c['name'])."</td><td>".htmlspecialchars($c['subject'])."</td><td>".htmlspecialchars($c['status'])."</td><td>";
        echo "<form method='post' style='display:inline;'><input type='hidden' name='campaign_id' value='".$c['id']."'><button name='start_campaign' class='btn small'>Start</button></form>";
        echo "</td></tr>";
    } ?>
    </table>
</div></body></html>
