<?php
session_start();
require __DIR__ . '/../config.php';
if (!isset($_SESSION['admin_id'])) header('Location: login.php');
$pdo = get_pdo();
$msg = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['create_template'])) {
        $stmt = $pdo->prepare("INSERT INTO templates (name, html) VALUES (?,?)");
        $stmt->execute([$_POST['name'], $_POST['html']]);
        $msg = 'Template saved';
    }
    if (isset($_POST['upload_image']) && isset($_FILES['image'])) {
        $template_id = intval($_POST['template_id']);
        $filename = time() . '_' . basename($_FILES['image']['name']);
        $dest = __DIR__ . '/../uploads/' . $filename;
        move_uploaded_file($_FILES['image']['tmp_name'], $dest);
        $stmt = $pdo->prepare("INSERT INTO template_images (template_id, filename) VALUES (?,?)");
        $stmt->execute([$template_id, $filename]);
        $msg = 'Image uploaded';
    }
}
$templates = $pdo->query('SELECT * FROM templates')->fetchAll();
?>
<!doctype html><html><head><meta charset="utf-8"><title>Templates</title><link rel="stylesheet" href="/assets/css/style.css"></head><body>
<nav class="top"><a href="dashboard.php">Dashboard</a></nav>
<div class="container">
    <h1>Templates</h1>
    <?php if($msg):?><div class="info"><?php echo $msg;?></div><?php endif;?>
    <form method="post">
        <label>Name</label><input name="name" required>
        <label>HTML (use [[NAME]] to personalize)</label>
        <textarea name="html" rows="10" required></textarea>
        <button name="create_template" class="btn">Save Template</button>
    </form>
    <h3>Upload Image to Template</h3>
    <form method="post" enctype="multipart/form-data">
        <label>Select Template</label>
        <select name="template_id"><?php foreach($templates as $t){echo "<option value='{$t['id']}'>".htmlspecialchars($t['name'])."</option>";}?></select>
        <input type="file" name="image" accept="image/*" required>
        <button name="upload_image" class="btn">Upload Image</button>
    </form>
    <h3>Saved Templates</h3>
    <ul><?php foreach($templates as $t){ echo "<li>".htmlspecialchars($t['name'])."</li>";}?></ul>
</div></body></html>
