<?php
// Endpoint to receive AWS SNS notifications for bounces/complaints
// Configure your SNS topic to send notifications (JSON) to this endpoint.
require __DIR__ . '/../config.php';
$pdo = get_pdo();
$json = file_get_contents('php://input');
if (!$json) {
    http_response_code(400);
    exit;
}
$msg = json_decode($json, true);
if (!$msg) { http_response_code(400); exit; }

// Handle SNS subscription confirmation
if (isset($msg['Type']) && $msg['Type'] === 'SubscriptionConfirmation' && isset($msg['SubscribeURL'])) {
    // In production, you may want to auto-confirm by fetching SubscribeURL.
    file_put_contents('sns_confirm.log', $msg['SubscribeURL'] . PHP_EOL, FILE_APPEND);
    echo 'ok';
    exit;
}

// Notification with bounce/complaint
if (isset($msg['Type']) && $msg['Type'] === 'Notification') {
    $notification = json_decode($msg['Message'], true);
    if (!$notification) { echo 'no'; exit; }

    // Example: bounce -> notification['bounce']['bouncedRecipients'] -> emailAddress
    if (isset($notification['bounce'])) {
        $recipients = $notification['bounce']['bouncedRecipients'] ?? [];
        foreach ($recipients as $r) {
            $email = $r['emailAddress'];
            // Mark contact as bounced
            $stmt = $pdo->prepare("UPDATE list_contacts SET bounced=1 WHERE email=?");
            $stmt->execute([$email]);
        }
    }
    if (isset($notification['complaint'])) {
        $recipients = $notification['complaint']['complainedRecipients'] ?? [];
        foreach ($recipients as $r) {
            $email = $r['emailAddress'];
            // treat complaint as unsubscribe
            $stmt = $pdo->prepare("UPDATE list_contacts SET unsubscribed=1 WHERE email=?");
            $stmt->execute([$email]);
        }
    }
    echo 'ok';
    exit;
}

echo 'noop';
exit;
