<?php
// Unsubscribe link: public/unsubscribe.php?cid=CONTACT_ID&token=TOKEN
require __DIR__ . '/../config.php';
require __DIR__ . '/../vendor/autoload.php';
use PHPMailer\PHPMailer\PHPMailer;
$pdo = get_pdo();

$contact = isset($_GET['cid']) ? intval($_GET['cid']) : 0;
$token = isset($_GET['token']) ? $_GET['token'] : '';

if (!$contact) {
    echo "Invalid request";
    exit;
}

$conf = get_config();
$expected = md5($contact . ($conf['unsubscribe_secret'] ?? 'secret_key'));
if ($token !== $expected) {
    echo "Invalid token";
    exit;
}

// Instead of immediately unsubscribing, send confirmation email with link
// If contact already unsubscribed, tell them
$stmt = $pdo->prepare("SELECT * FROM list_contacts WHERE id=?");
$stmt->execute([$contact]);
$c = $stmt->fetch();
if (!$c) { echo 'Contact not found'; exit; }
if ($c['unsubscribed']) { echo 'You are already unsubscribed.'; exit; }

// send confirmation email with confirm_unsubscribe.php link
try {
    $mail = new PHPMailer(true);
    $mail->isSMTP();
    $mail->Host = $conf['smtp']['host'];
    $mail->SMTPAuth = true;
    $mail->Username = $conf['smtp']['username'];
    $mail->Password = $conf['smtp']['password'];
    $mail->SMTPSecure = $conf['smtp']['secure'];
    $mail->Port = $conf['smtp']['port'];
    $mail->setFrom($conf['from']['email'], $conf['from']['name']);
    $mail->addAddress($c['email'], $c['name']);
    $mail->isHTML(true);
    $token2 = md5($contact . 'unsub2' . ($conf['unsubscribe_secret'] ?? 'secret_key'));
    $confirm_url = $conf['base_url'] . '/public/confirm_unsubscribe.php?cid=' . $contact . '&token=' . $token2;
    $mail->Subject = 'Confirm unsubscribe';
    $mail->Body = "<p>Hello " . htmlspecialchars($c['name']) . ",</p><p>Please confirm your unsubscribe by clicking the link below:</p><p><a href='".$confirm_url."'>Confirm unsubscribe</a></p>";
    $mail->send();
    echo 'A confirmation email has been sent to your address. Please click the link in that email to complete unsubscribe.';
} catch (Exception $e) {
    // if sending fails, fallback to immediate unsubscribe
    $stmt = $pdo->prepare("UPDATE list_contacts SET unsubscribed=1 WHERE id=?");
    $stmt->execute([$contact]);
    echo 'You have been unsubscribed.';
}
exit;
