<?php



session_start();
require_once __DIR__ . '/../config.php';
if(!isset($_SESSION['admin_id'])) header('Location: login.php');

session_start();
require_once __DIR__ . '/../config.php';
if(!isset($_SESSION['admin_id'])) header('Location: login.php');

$pdo = get_pdo();
$totals = [];
$totals['lists'] = $pdo->query('SELECT COUNT(*) FROM lists')->fetchColumn();
$totals['templates'] = $pdo->query('SELECT COUNT(*) FROM templates')->fetchColumn();
$totals['campaigns'] = $pdo->query('SELECT COUNT(*) FROM campaigns')->fetchColumn();
$totals['contacts'] = $pdo->query('SELECT COUNT(*) FROM contacts')->fetchColumn();
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Admin Dashboard</title>
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
 <link rel="stylesheet" href="./includes/style.css"> 
</head>
<body>
    <div class="sidebar">
        <h2>📊 Admin Panel</h2>
        <a href="dashboard.php" class="active">🏠 Dashboard</a>
        <a href="lists.php">📋 Lists</a>
        <a href="templates.php">📄 Templates</a>
        <a href="campaigns.php">📧 Campaigns</a>
        <a href="reports.php">📊 Reports</a>
        <a href="contacts.php">👥 Contacts</a>
        <a href="logout.php">🚪 Logout</a>
    </div>

    <div class="main-content">
        <div class="header">
            <h1>Welcome Back, Admin 👋</h1>
            <div>
                <button class="toggle-btn" id="modeToggle">🌙 Dark Mode</button>
                <a class="logout-btn" href="logout.php">Logout</a>
            </div>
        </div>

        <div class="dashboard-content">
            <div class="card-grid">
                <div class="card"><h3>Total Lists</h3><span><?= $totals['lists']; ?></span></div>
                <div class="card"><h3>Total Templates</h3><span><?= $totals['templates']; ?></span></div>
                <div class="card"><h3>Total Campaigns</h3><span><?= $totals['campaigns']; ?></span></div>
                <div class="card"><h3>Total Contacts</h3><span><?= $totals['contacts']; ?></span></div>
            </div>

            <div class="chart-grid">
                <div class="chart-container">
                    <h3>📈 Emails Sent (Last 6 Months)</h3>
                    <canvas id="campaignChart" height="120"></canvas>
                </div>
                <div class="chart-container">
                    <h3>📊 Campaign Status Overview</h3>
                    <canvas id="statusChart" height="120"></canvas>
                </div>
            </div>

            <div class="chart-container">
                <h3>📧 Email Performance (Open / Bounce Rate)</h3>
                <canvas id="performanceChart" height="100"></canvas>
            </div>
        </div>
    </div>

<script>
const ctx1 = document.getElementById('campaignChart');
const ctx2 = document.getElementById('statusChart');
const ctx3 = document.getElementById('performanceChart');

new Chart(ctx1, {
    type: 'line',
    data: {
        labels: ['June', 'July', 'Aug', 'Sept', 'Oct', 'Nov'],
        datasets: [{
            label: 'Emails Sent',
            data: [200, 450, 380, 600, 720, 510],
            borderColor: '#3b82f6',
            backgroundColor: 'rgba(59,130,246,0.1)',
            borderWidth: 2,
            fill: true,
            tension: 0.4
        }]
    },
    options: { plugins: { legend: { display: false } } }
});

new Chart(ctx2, {
    type: 'pie',
    data: {
        labels: ['Sent', 'Opened', 'Bounced', 'Unsubscribed'],
        datasets: [{
            data: [60, 25, 10, 5],
            backgroundColor: ['#3b82f6','#10b981','#f59e0b','#ef4444']
        }]
    }
});

new Chart(ctx3, {
    type: 'bar',
    data: {
        labels: ['Campaign 1','Campaign 2','Campaign 3','Campaign 4'],
        datasets: [
            { label: 'Open Rate', data: [68,72,58,80], backgroundColor:'#10b981' },
            { label: 'Bounce Rate', data: [6,8,5,7], backgroundColor:'#ef4444' }
        ]
    },
    options: { scales: { y: { beginAtZero:true } } }
});

// Dark mode toggle
const btn = document.getElementById('modeToggle');
btn.onclick = () => {
    document.body.classList.toggle('dark');
    btn.textContent = document.body.classList.contains('dark') ? '☀️ Light Mode' : '🌙 Dark Mode';
};
</script>
</body>
</html>
