<?php
session_start();
require __DIR__ . '/../config.php';
if (!isset($_SESSION['admin_id'])) header('Location: login.php');
$pdo = get_pdo();
// simple stats
$totals = [];
$totals['lists'] = $pdo->query('SELECT COUNT(*) FROM lists')->fetchColumn();
$totals['templates'] = $pdo->query('SELECT COUNT(*) FROM templates')->fetchColumn();
$totals['campaigns'] = $pdo->query('SELECT COUNT(*) FROM campaigns')->fetchColumn();
?>
<!doctype html>
<html>
<head>
    <meta charset="utf-8">
    <title>Admin Dashboard</title>
    <link rel="stylesheet" href="/assets/css/style.css">
</head>
<body>
<nav class="top">
    <a href="dashboard.php">Dashboard</a> |
    <a href="lists.php">Lists</a> |
    <a href="templates.php">Templates</a> |
    <a href="campaigns.php">Campaigns</a> |
    <a href="reports.php">Reports</a>
</nav>
<div class="container">
    <h1>Dashboard</h1>
    <div class="grid">
        <div class="card small">Lists<br><?php echo $totals['lists'];?></div>
        <div class="card small">Templates<br><?php echo $totals['templates'];?></div>
        <div class="card small">Campaigns<br><?php echo $totals['campaigns'];?></div>
    </div>
</div>
</body>
</html>
